<?php
require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') json_out(['success'=>false,'error'=>'Method not allowed'], 405);

$in = json_in();
$email = strtolower(trim($in['email'] ?? ''));
$pass  = (string)($in['password'] ?? '');

if (!$email || !$pass) json_out(['success'=>false,'error'=>'Missing fields'], 422);

$pdo = db();
$st = $pdo->prepare("SELECT id, email, password_hash FROM admin_users WHERE email = ? LIMIT 1");
$st->execute([$email]);
$row = $st->fetch();

if (!$row || !password_verify($pass, $row['password_hash'])) {
  json_out(['success'=>false,'error'=>'Invalid credentials'], 401);
}

$token = create_token((int)$row['id']);

json_out([
  'success'=>true,
  'admin'=>['id'=>(int)$row['id'], 'email'=>$row['email']],
  'token'=>$token
]);
