<?php
require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') json_out(['success'=>false,'error'=>'Method not allowed'], 405);

$in = json_in();
$email = strtolower(trim($in['email'] ?? ''));
$pass  = (string)($in['password'] ?? '');

if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) json_out(['success'=>false,'error'=>'Invalid email'], 422);
if (strlen($pass) < 6) json_out(['success'=>false,'error'=>'Password too short'], 422);

$pdo = db();

// check unique
$st = $pdo->prepare("SELECT id FROM admin_users WHERE email = ? LIMIT 1");
$st->execute([$email]);
if ($st->fetch()) json_out(['success'=>false,'error'=>'Email already exists'], 409);

$hash = password_hash($pass, PASSWORD_BCRYPT);
$st = $pdo->prepare("INSERT INTO admin_users (email, password_hash) VALUES (?, ?)");
$st->execute([$email, $hash]);
$admin_id = (int)$pdo->lastInsertId();

$token = create_token($admin_id);

json_out([
  'success' => true,
  'admin' => ['id'=>$admin_id, 'email'=>$email],
  'token' => $token,
], 201);
