<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/helpers.php';

function bearer_token(): ?string {
  $h = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
  if (!$h) return null;
  if (preg_match('/Bearer\s+(.+)/i', $h, $m)) return trim($m[1]);
  return null;
}

function create_token(int $admin_id): string {
  $token = bin2hex(random_bytes(32));           // 64 chars
  $hash  = hash('sha256', $token);

  $pdo = db();
  $stmt = $pdo->prepare("INSERT INTO admin_tokens (admin_user_id, token_hash, expires_at) VALUES (?, ?, DATE_ADD(NOW(), INTERVAL 30 DAY))");
  $stmt->execute([$admin_id, $hash]);

  return $token; // plain token to client
}

function require_admin(): array {
  $token = bearer_token();
  if (!$token) json_out(['success'=>false,'error'=>'Missing token'], 401);

  $hash = hash('sha256', $token);

  $pdo = db();
  $stmt = $pdo->prepare("
    SELECT au.id, au.email
    FROM admin_tokens t
    JOIN admin_users au ON au.id = t.admin_user_id
    WHERE t.token_hash = ?
      AND (t.expires_at IS NULL OR t.expires_at > NOW())
    LIMIT 1
  ");
  $stmt->execute([$hash]);
  $admin = $stmt->fetch();

  if (!$admin) json_out(['success'=>false,'error'=>'Invalid token'], 401);
  return $admin;
}

function delete_current_token(): void {
  $token = bearer_token();
  if (!$token) return;
  $hash = hash('sha256', $token);

  $pdo = db();
  $stmt = $pdo->prepare("DELETE FROM admin_tokens WHERE token_hash = ?");
  $stmt->execute([$hash]);
}
